<html>
	<head>
		<title>Creacio de la base de dades i les taules</title>
		<link rel="stylesheet" type="text/css" href="css/css.css">
	</head>
	<body>
		<h1>Creacio de la base de dades i les taules</h1>
		<h2>en mySQL</h2>
		<?php
			//Inclueix els arxiua necesaris per gestionar la base de dades:
			require_once "lib/bd.php";

			//Genera el codi per crear les taules:
			$creacio_bd = "CREATE DATABASE IF NOT EXISTS " . BD_NOM;
			$creacio_taules = Array(
									"colleccions" => "CREATE TABLE IF NOT EXISTS colleccions(
														COL_id BIGINT PRIMARY KEY AUTO_INCREMENT,
														COL_nom VARCHAR(250) NOT NULL
														);",
									"subcolleccions" => "CREATE TABLE IF NOT EXISTS subcolleccions(
															SUB_id BIGINT PRIMARY KEY AUTO_INCREMENT,
															SUB_titol VARCHAR(250) NOT NULL,
															SUB_text TEXT,
															SUB_opcio_ver_coleccion BOOL NOT NULL DEFAULT TRUE,
															SUB_colleccio BIGINT NOT NULL,
															SUB_visible BOOL NOT NULL DEFAULT TRUE
														);",
									"llibres" => "CREATE TABLE IF NOT EXISTS llibres(
													LLI_id BIGINT PRIMARY KEY AUTO_INCREMENT,
													LLI_titol VARCHAR(250) NOT NULL,
													LLI_objectius TEXT,
													LLI_ordre INT NOT NULL DEFAULT 0,
													LLI_subapartat VARCHAR(250),
													LLI_subcolleccio BIGINT NOT NULL
													);",
									"apartats_subcolleccions" => "CREATE TABLE IF NOT EXISTS apartats_subcolleccions(
																	APACOL_id BIGINT NOT NULL,
																	APACOL_subcolleccio BIGINT NOT NULL,
																	APACOL_ordre INT NOT NULL DEFAULT 0,
																	PRIMARY KEY (APACOL_id, APACOL_subcolleccio)
																	);",
									"apartats" => "CREATE TABLE IF NOT EXISTS apartats(
													APA_id BIGINT PRIMARY KEY AUTO_INCREMENT,
													APA_nom varchar(250)
													);"
									);

			//Crea l'objecte de la base de dades:
			$bd = new base_dades();
	
			//Connecta:
			$bd->connecta();
			if ($bd->connexio) { echo "Connexio a mySQL realitzada!<br>"; }

			//Crea la base de dades:
			$creacio = $bd->fes_consulta($creacio_bd);
			if ($creacio) { echo "* Base de dades <b>" . BD_NOM . "</b> creada satisfactoriament.<br>"; }
			else { echo "[<b>ERROR</b>] No es pot crear la base de dades <b>" . BD_NOM . "</b>"; }
	
			//Sellecciona la base de dades:
			$bd->sellecciona("");
	
			//Crea les taules:
			foreach ($creacio_taules as $taula => $consulta)
			{
				if (trim($consulta) != "")
				{
					$creacio = $bd->fes_consulta($consulta);
					if ($creacio) { echo "&nbsp;&nbsp; * Taula <b>" . $taula . "</b> creada satisfactoriament.<br>"; }
					else { echo "* [<b>ERROR</b>] No es pot crear la taula " . $taula . "!<br>"; }
				}
			}

			//Desconnecta:
			$bd->desconnecta();
		?>
	</body>
</html>